function F = tf_features(Y)
% Extract time and frequency features from segments of a signal.
% The features are listed in Table 4, Gao et al, Applied Soft Computing, 2021.

% BD 31.03.2025

[m,N] = size(Y);  % m - number of features, N - number of signals

F = zeros(27,N); % 27 features initially

% time features
F(1,:) = mean(Y); % mean
F(2,:) = rms(Y); % root mean square
F(3,:) = mean(sqrt(abs(Y))).^2; % mean of square roots, squared
F(4,:) = mean(abs(Y)); % mean of absolute values
F(5,:) = std(Y); % standard deviation
F(6,:) = max(Y);
F(7,:) = min(Y);
F(8,:) = F(6,:) - F(7,:);
F(9,:) = F(2,:) ./ F(4,:);
F(10,:) = F(6,:) ./ F(2,:);
F(11,:) = F(6,:) ./ F(4,:);
F(12,:) = F(6,:) ./ F(3,:);
F(13,:) = sum(((Y-F(1,:))./(F(2,:).^2)).^3) / (m-1);
F(14,:) = sum(((Y-F(1,:))./(F(2,:).^2)).^4) / (m-1);

% frequency features
Yfft = fft(Y);
m2 = m/2+1;
Yfft = abs(Yfft(1:m2,:));
w = 0:2/m:1;
F(15,:) = mean(Yfft);
F(16,:) = std(Yfft).^2;
F(17,:) = sum(((Yfft-F(15,:))./(sqrt(F(16,:).^2))).^3) / m2;
%F(18,:) = sum((Yfft - F(15,:)).^4)/m2/(F(16,:)).^2;
F(19,:) = sum(Yfft.*w')./sum(Yfft);
F(20,:) = sqrt(sum((w'-F(19,:)).^2 .* Yfft)) / m2;
F(21,:) = sqrt(sum(Yfft.*(w.*w)')./sum(Yfft));
F(22,:) = sqrt(sum(Yfft.*(w.*w.*w.*w)')./sum(Yfft.*(w.*w)'));
F(23,:) = sum(Yfft.*(w.*w)') ./ sqrt(sum(Yfft) .* sum(Yfft.*(w.*w.*w.*w)'));
%F(24,:) = F(20,:) / F(19,:);
F(25,:) = sum((w'-F(19,:)).^3 .* Yfft) ./ F(20,:).^3 / m2;
F(26,:) = sum((w'-F(19,:)).^4 .* Yfft) ./ F(20,:).^4 / m2;
F(27,:) = sum(sqrt(abs(w'-F(19,:))) .* Yfft) ./ F(20,:) / m2;

% !!! remove these two features as they may have very large values and they
% may give poor anomaly detection results
F([18 24],:)=[];

