function scores = octvreg(Xnormal, Xtest, K, lam, dist)
% OC-TVreg (One-Class anomaly detection with Total Variation regularization)
% Input:
%   Xnormal - normal data matrix (number of samples x number of features)
%   Xtest   - test data matrix (contains normal samples and anomalies)
%   K       - number of nearest neighors
%   lam     - regularization factor
%   dist    - distance (0=cosine similarity, 1=Euclidean)
% Output:
%   scores  - scores associated with test data (higher value more likely for anomaly)

% BD 5.04.2025

if nargin < 5
  dist = 0;
end
[nn,m] = size(Xnormal);
nt = size(Xtest,1);
X = [Xnormal; Xtest];

% build graph Laplacian using distances between signals
switch dist
  case 0
    A = pdist2(X, X, "cosine");   % distances between signals: cosine similarity
  case 1
    A = pdist2(X, X, "euclidean");   % distances between signals: Euclidean
end
i = mink(A,K+1,2); % distances to K nearest neighbors (consider also the diagonal zero)
A(A>i(:,K+1)) = 0; % keep only the K nearest neighbors
A = max(A,A');     % symmetrize
d = sum(A,2);      % degrees
L = diag(d) - A;   % Laplacian

% solve quadratic optimization problem
L = L+lam*eye(nn+nt);
%scores = - L(nn+1:end,nn+1:end) \ sum(L(nn+1:end,1:nn),2);
opts.SYM = true;
opts.POSDEF = true;
scores = -linsolve(L(nn+1:end,nn+1:end), sum(L(nn+1:end,1:nn),2), opts);
scores = - scores;
